/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app.print;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.PrintOptionsPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.block.ClockBlock;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.app.print.CommentPagePrinter;
import DE.siemens.ad.pdraw.app.print.ConnectorNamesPrinter;
import DE.siemens.ad.pdraw.app.print.DrawingPrinter;
import DE.siemens.ad.pdraw.app.print.EthernetPagePrinter;
import DE.siemens.ad.pdraw.app.print.LogoPrintBook;
import DE.siemens.ad.pdraw.app.print.ParameterPagePrinter;
import DE.siemens.ad.pdraw.app.print.VMMappingPagerPrinter;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Vector;

public class LogoPrinter {
    protected LogoDrawing fDrawing;
    protected LogoProperties fLogoProperties;
    protected LogoComfort fLogoComfort;
    private static PrinterJob cPrinterJob;

    public LogoPrinter(LogoComfort logoComfort) {
        this.fLogoComfort = logoComfort;
        this.fDrawing = (LogoDrawing)logoComfort.drawing();
        this.fLogoProperties = LogoProperties.instance();
    }

    public Vector getBlocksToPrint() {
        LogoDrawingView drawingView = (LogoDrawingView)this.fLogoComfort.view();
        Vector selectedFigures = drawingView.selection();
        CommentManager commentManager = ((LogoDrawing)drawingView.drawing()).getCommentManager();
        Vector<Block> blocksToPrint = new Vector<Block>();
        FigureEnumeration figures = this.fDrawing.figures();
        Figure figure = null;
        while (figures.hasMoreElements()) {
            figure = figures.nextFigure();
            if (!(figure instanceof BlockFigure)) continue;
            BlockFigure blockFigure = (BlockFigure)figure;
            Block block = blockFigure.getBlock();
            CommentParameter commentParameter = commentManager.getCommentParameter(block);
            if (!(block instanceof SpecialBlock) && (commentParameter == null || commentParameter.getText() == null || commentParameter.getText().trim().equals(""))) continue;
            if (this.isPrintAllParameters()) {
                blocksToPrint.add(blockFigure.getBlock());
                continue;
            }
            if (this.isPrintSelectedParameters() && selectedFigures.contains(blockFigure)) {
                blocksToPrint.add(blockFigure.getBlock());
                continue;
            }
            if (!this.isPrintClockParameters() || !(blockFigure.getBlock() instanceof ClockBlock)) continue;
            blocksToPrint.add(blockFigure.getBlock());
        }
        return blocksToPrint;
    }

    public LogoPrintBook getBook(Graphics g) {
        Hardware fHardware;
        PageFormat pf = null;
        LogoPrintBook book = new LogoPrintBook();
        boolean changeOrientationPossible = this.isChangeOrientationPossible();
        int commentPageCount = 0;
        int totalPages = 0;
        CommentPagePrinter commentPrinter = null;
        EthernetPagePrinter ethernetPagePrinter = null;
        VMMappingPagerPrinter vmPagePrinter = null;
        DrawingPrinter drawingPrinter = null;
        ParameterPagePrinter parameterPagePrinter = null;
        ConnectorNamesPrinter connectorNamesPrinter = null;
        if (this.isPrintCommentPage()) {
            commentPrinter = new CommentPagePrinter(this.fDrawing);
            pf = this.getPageFormatForPrint();
            if (this.isChangeOrientationPossible()) {
                pf.setOrientation(1);
            }
            commentPageCount = commentPrinter.getPageCount(pf, g);
            book.append(commentPrinter, pf, commentPageCount);
            totalPages += commentPageCount;
        }
        if ((fHardware = ((LogoDrawing)((LogoDrawingView)Application.getInstance().getActiveApplicationSurface().getEditor().getView()).drawing()).getWiringDiagram().getHardware()).supports("supportNetwork")) {
            if (this.isPrintEthernetPage()) {
                ethernetPagePrinter = new EthernetPagePrinter(this.fDrawing);
                pf = this.getPageFormatForPrint();
                int ethernetPageCount = ethernetPagePrinter.getPageCount(pf, g);
                book.append(ethernetPagePrinter, pf, ethernetPageCount);
                totalPages += ethernetPageCount;
            }
            if (this.isPrintVMMappingPage()) {
                vmPagePrinter = new VMMappingPagerPrinter(this.fDrawing);
                pf = this.getPageFormatForPrint();
                int vmPageCount = vmPagePrinter.getPageCount(pf, g);
                book.append(vmPagePrinter, pf, vmPageCount);
                totalPages += vmPageCount;
            }
        }
        if (this.isPrintDrawing()) {
            drawingPrinter = new DrawingPrinter(this.fDrawing, this.isSuppressEmptyPages());
            pf = this.getPageFormatForPrint();
            book.append(drawingPrinter, pf, drawingPrinter.getPageCount(pf, g));
            totalPages += drawingPrinter.getPageCount(pf, g);
        }
        if (this.isPrintParameterList()) {
            parameterPagePrinter = new ParameterPagePrinter(this.fDrawing, this.getBlocksToPrint());
            pf = this.getPageFormatForPrint();
            if (this.isChangeOrientationPossible()) {
                pf.setOrientation(1);
            }
            parameterPagePrinter.setPageNumberOffset(-commentPageCount);
            book.append(parameterPagePrinter, pf, parameterPagePrinter.getPageCount(pf, g));
            totalPages += parameterPagePrinter.getPageCount(pf, g);
        }
        if (this.isPrintConnectornameList()) {
            connectorNamesPrinter = new ConnectorNamesPrinter(this.fDrawing);
            pf = this.getPageFormatForPrint();
            if (this.isChangeOrientationPossible()) {
                pf.setOrientation(1);
            }
            connectorNamesPrinter.setPageNumberOffset(-commentPageCount);
            book.append(connectorNamesPrinter, pf, connectorNamesPrinter.getPageCount(pf, g));
            totalPages += connectorNamesPrinter.getPageCount(pf, g);
        }
        if (null != commentPrinter) {
            commentPrinter.setTotalPage(totalPages);
        }
        if (fHardware.supports("supportNetwork")) {
            if (ethernetPagePrinter != null) {
                ethernetPagePrinter.setTotalPage(totalPages);
            }
            if (vmPagePrinter != null) {
                vmPagePrinter.setTotalPage(totalPages);
            }
        }
        if (null != drawingPrinter) {
            drawingPrinter.setTotalPage(totalPages);
        }
        if (null != parameterPagePrinter) {
            parameterPagePrinter.setTotalPage(totalPages);
        }
        if (null != connectorNamesPrinter) {
            connectorNamesPrinter.setTotalPage(totalPages);
        }
        book.setName(Application.getName() + " - " + this.fDrawing.getFile().getName());
        return book;
    }

    public LogoPrintBook getBook() {
        return this.getBook(new BufferedImage(1, 1, 1).getGraphics());
    }

    private boolean isChangeOrientationPossible() {
        return !System.getProperty("os.name", "unknown").equals("Mac OS X");
    }

    public Editor getEditor() {
        return this.fLogoComfort;
    }

    public PageFormat getPageFormatForPrint() {
        LogoDrawing drawing = this.fDrawing;
        PageFormat drawingFormat = drawing.getPageFormat();
        return drawingFormat;
    }

    public boolean isPrintAllParameters() {
        return this.fLogoProperties.getBooleanProperty("print.printAllParameters", true);
    }

    public boolean isSuppressEmptyPages() {
        return this.fLogoProperties.getBooleanProperty("print.suppressEmptyPages", false);
    }

    public void setSuppressEmptyPages(boolean suppressEmptyPages) {
        this.fLogoProperties.setBooleanProperty("print.suppressEmptyPages", suppressEmptyPages);
    }

    public boolean isPrintClockParameters() {
        return this.fLogoProperties.getBooleanProperty("print.printClockParameters", false);
    }

    public boolean isPrintCommentPage() {
        return this.fLogoProperties.getBooleanProperty("print.printCommentPage", true);
    }

    public boolean isPrintEthernetPage() {
        return this.fLogoProperties.getBooleanProperty("print.printEthernetPage", true);
    }

    public boolean isPrintVMMappingPage() {
        return this.fLogoProperties.getBooleanProperty("print.printVMMappingPage", true);
    }

    public boolean isPrintConnectornameList() {
        return this.fLogoProperties.getBooleanProperty("print.printConnectornameList", true);
    }

    public boolean isPrintConnectorNamesInDrawing() {
        return this.fLogoProperties.getBooleanProperty("print.drawing.printConnectorNames", true);
    }

    public boolean isPrintDrawing() {
        return this.fLogoProperties.getBooleanProperty("print.printDrawing", true);
    }

    public boolean isPrintParameterList() {
        return this.fLogoProperties.getBooleanProperty("print.printParameterList", true);
    }

    public boolean isPrintParametersInDrawing() {
        return this.fLogoProperties.getBooleanProperty("print.drawing.printParameters", true);
    }

    public boolean isPrintSelectedParameters() {
        return this.fLogoProperties.getBooleanProperty("print.printSelectedParameters", false);
    }

    public void print() {
        PrinterJob printJob = LogoPrinter.getPrinterJob();
        LogoPrintBook book = this.getBook();
        printJob.setPageable(book);
        printJob.setJobName(book.getName());
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setPrintAllParameters(boolean newPrintAllParameters) {
        this.fLogoProperties.setBooleanProperty("print.printAllParameters", newPrintAllParameters);
    }

    public void setPrintClockParameters(boolean newPrintClockParameters) {
        this.fLogoProperties.setBooleanProperty("print.printClockParameters", newPrintClockParameters);
    }

    public void setPrintCommentPage(boolean newPrintCommentPage) {
        this.fLogoProperties.setBooleanProperty("print.printCommentPage", newPrintCommentPage);
    }

    public void setPrintEthernetPage(boolean newPrintEthernetPage) {
        this.fLogoProperties.setBooleanProperty("print.printEthernetPage", newPrintEthernetPage);
    }

    public void setPrintVMMappingPage(boolean newPrintVMMappingPage) {
        this.fLogoProperties.setBooleanProperty("print.printVMMappingPage", newPrintVMMappingPage);
    }

    public void setPrintConnectornameList(boolean newPrintConnectornameList) {
        this.fLogoProperties.setBooleanProperty("print.printConnectornameList", newPrintConnectornameList);
    }

    public void setPrintConnectorNamesInDrawing(boolean newPrintConnectorNamesInDrawing) {
        this.fLogoProperties.setBooleanProperty("print.drawing.printConnectorNames", newPrintConnectorNamesInDrawing);
    }

    public void setPrintDrawing(boolean newPrintDrawing) {
        this.fLogoProperties.setBooleanProperty("print.printDrawing", newPrintDrawing);
    }

    public void setPrintParameterList(boolean newPrintParameterList) {
        this.fLogoProperties.setBooleanProperty("print.printParameterList", newPrintParameterList);
    }

    public void setPrintParametersInDrawing(boolean newPrintParametersInDrawing) {
        this.fLogoProperties.setBooleanProperty("print.drawing.printParameters", newPrintParametersInDrawing);
    }

    public void setPrintSelectedParameters(boolean newPrintSelectedParameters) {
        this.fLogoProperties.setBooleanProperty("print.printSelectedParameters", newPrintSelectedParameters);
    }

    public int showPrintScopeDialog() {
        PrintOptionsPanel printOptionsPanel = new PrintOptionsPanel(this);
        SplittedDlg dialog = SplittedDlg.create(this.fLogoComfort.getApplicationSurface().getWindow(), printOptionsPanel, 11);
        dialog.show();
        return dialog.getControlPanel().getResult();
    }

    public static PrinterJob getPrinterJob() {
        if (cPrinterJob == null) {
            cPrinterJob = PrinterJob.getPrinterJob();
        }
        return cPrinterJob;
    }

    public void setPrintZoom(int zoom) {
        LogoProperties.instance().setIntProperty("printZoom", zoom);
        if (this.fDrawing != null) {
            this.fDrawing.setPrintZoom((double)zoom / 100.0);
        }
    }

    public int getPrintZoom() {
        return LogoProperties.instance().getIntProperty("printZoom", 50);
    }
}

